/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.decorative.BlockConstructionTape;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.util.ColonyUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstructionTapeHelper {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty CORNER = BooleanProperty.func_177716_a((String)"corner");

    private ConstructionTapeHelper() {
    }

    public static void placeConstructionTape(@NotNull WorkOrderDecoration workOrder, @NotNull World world) {
        Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(workOrder.getLocation(), world, new LoadOnlyStructureHandler(world, workOrder.getLocation(), workOrder.getStructureName(), new PlacementSettings(), true).getBluePrint(), workOrder.getRotation(), workOrder.isMirrored());
        ConstructionTapeHelper.placeConstructionTape(corners, world);
    }

    public static void placeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, @NotNull World world) {
        BlockPos working;
        if (!((Boolean)MineColonies.getConfig().getServer().builderPlaceConstructionTape.get()).booleanValue()) {
            return;
        }
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.func_76341_a()).func_177982_a(-1, 0, -1), (Object)((BlockPos)orgCorners.func_76340_b()).func_177982_a(1, 0, 1));
        BlockState constructionTape = ModBlocks.blockConstructionTape.func_176223_P();
        int x = Math.min(((BlockPos)corners.func_76341_a()).func_177958_n(), ((BlockPos)corners.func_76340_b()).func_177958_n());
        int y = Math.max(((BlockPos)corners.func_76341_a()).func_177956_o(), ((BlockPos)corners.func_76340_b()).func_177956_o());
        int z = Math.min(((BlockPos)corners.func_76341_a()).func_177952_p(), ((BlockPos)corners.func_76340_b()).func_177952_p());
        int sizeX = Math.abs(((BlockPos)corners.func_76341_a()).func_177958_n() - ((BlockPos)corners.func_76340_b()).func_177958_n());
        int sizeZ = Math.abs(((BlockPos)corners.func_76341_a()).func_177952_p() - ((BlockPos)corners.func_76340_b()).func_177952_p());
        int sizeY = Math.abs(((BlockPos)corners.func_76341_a()).func_177956_o() - ((BlockPos)corners.func_76340_b()).func_177956_o());
        BlockPos place = new BlockPos(x, y, z);
        while (place.func_177958_n() < x + sizeX || place.func_177952_p() < z + sizeZ) {
            if (place.func_177958_n() < x + sizeX) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.func_177958_n(), y, z), world, sizeY);
                if (working != null) {
                    world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(place.func_177958_n() == x)), (IBlockReader)world, working, Direction.SOUTH));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.func_177958_n(), y, z + sizeZ), world, sizeY)) != null) {
                    world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(place.func_177958_n() == x)), (IBlockReader)world, working, Direction.NORTH));
                }
            }
            if (place.func_177952_p() < z + sizeZ) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x, y, place.func_177952_p()), world, sizeY);
                if (working != null) {
                    world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(place.func_177952_p() == z)), (IBlockReader)world, working, Direction.EAST));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, place.func_177952_p()), world, sizeY)) != null) {
                    world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(place.func_177952_p() == z)), (IBlockReader)world, working, place.func_177952_p() == z ? Direction.SOUTH : Direction.WEST));
                }
            }
            place = place.func_177968_d().func_177974_f();
        }
        working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, z + sizeZ), world, sizeY);
        if (working != null) {
            world.func_175656_a(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(true)), (IBlockReader)world, working, Direction.WEST));
        }
    }

    @Nullable
    public static BlockPos firstValidPosition(@NotNull BlockPos target, @NotNull World world, int height) {
        for (int i = 0; i <= height + 5; ++i) {
            BlockPos tempTarget = new BlockPos(target.func_177958_n(), target.func_177956_o() - i, target.func_177952_p());
            BlockState state = world.func_180495_p(tempTarget);
            BlockState upState = world.func_180495_p(tempTarget.func_177984_a());
            if (!state.func_200132_m() || upState.func_200132_m() || !upState.func_185904_a().func_76222_j() && !upState.isAir((IBlockReader)world, tempTarget.func_177984_a())) continue;
            return tempTarget.func_177984_a();
        }
        return null;
    }

    public static void removeConstructionTape(@NotNull IWorkOrder workOrder, @NotNull World world) {
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(world, workOrder.getLocation(), workOrder.getStructureName(), new PlacementSettings(), true);
        if (structure.hasBluePrint()) {
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(workOrder.getLocation(), world, structure.getBluePrint(), workOrder.getRotation(), workOrder.isMirrored());
            ConstructionTapeHelper.removeConstructionTape(corners, world);
        }
    }

    public static void removeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, @NotNull World world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.func_76341_a()).func_177982_a(-1, 0, -1), (Object)((BlockPos)orgCorners.func_76340_b()).func_177982_a(1, 0, 1));
        int x1 = ((BlockPos)corners.func_76341_a()).func_177958_n();
        int x3 = ((BlockPos)corners.func_76340_b()).func_177958_n();
        int z1 = ((BlockPos)corners.func_76341_a()).func_177952_p();
        int z3 = ((BlockPos)corners.func_76340_b()).func_177952_p();
        int minHeight = Math.min(((BlockPos)corners.func_76340_b()).func_177956_o(), ((BlockPos)corners.func_76341_a()).func_177956_o()) - 5;
        int maxHeight = Math.max(((BlockPos)corners.func_76340_b()).func_177956_o(), ((BlockPos)corners.func_76341_a()).func_177956_o()) + 1;
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTape, minHeight, maxHeight);
    }

    public static void removeTapeIfNecessary(@NotNull World world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner, int minHeight, int maxHeight) {
        for (int y = minHeight; y <= maxHeight; ++y) {
            BlockPos newBlock = new BlockPos(block.func_177958_n(), y, block.func_177952_p());
            if (world.func_180495_p(newBlock).func_177230_c() != tapeOrTapeCorner) continue;
            world.func_217377_a(newBlock, false);
            break;
        }
    }
}

